// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_DI_H
#define HW_DI_H

#include "hw_internal.h"

class HwDI {
public:
	static void ww_cvr(Hardware *h, WORD offset, DWORD data);
	static void ww_cr(Hardware *h, WORD offset, DWORD data);
	static void ww_sr(Hardware *h, WORD offset, DWORD data);
	static DWORD rw_cfg(Hardware *h, WORD offset);
	static DWORD rw_cvr(Hardware *h, WORD offset);
};

//Patented Registers
#define PR_DISR		0x6000
#define PR_DICVR	0x6004
#define PR_DICMDBUF0	0x6008
#define PR_DICMDBUF1	0x600C
#define PR_DICMDBUF2	0x6010
#define PR_DIMAR	0x6014
#define PR_DILENGH	0x6018
#define PR_DICR		0x601C
#define PR_DIMMBUF	0x6020
#define PR_DICFG	0x6024

#endif	//HW_DI_H
